<?php
//*************************************************************
// Include Config / Functions
//*************************************************************
require_once "Site-Config.php";
require_once "Site-Functions.php";
?>

<!DOCTYPE html>
<html lang="en-US" dir="ltr">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1">
	
	<link rel="shortcut icon" href="Images/Favicon.png">

	<link rel="stylesheet" href="Styles/Reset.min.css">
	<link rel="stylesheet" href="Styles/Font-Awesome.min.css">
	<link rel="stylesheet" href="Styles/Theme-1.css">
	<link rel="stylesheet" href="Styles/Site.css">
	
	<!--[if lt IE 9]>
		<script src="Scripts/HTML5-Shiv-Print.js"></script>
		<script src="Scripts/HTML5-Shiv.js"></script>
		<script src="Scripts/Placeholders.js"></script>
	<![endif]-->

	<script src="Scripts/JQuery.js"></script>
	<script src="Scripts/Site.js"></script>
	
	<?php if ( '' !== GOOGLE_ANALYTICS_ID ): ?>
		<script>
			(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
			(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
			m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
			})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

			ga('create', '<?php echo GOOGLE_ANALYTICS_ID; ?>', 'auto');
			ga('send', 'pageview');
		</script>
	<?php endif; ?>
	
	<?php if ( CAPTCHA_ENABLED ): ?>
		<script src="https://www.google.com/recaptcha/api.js"></script>
	<?php endif; ?>
	
	<title>Domain for Sale!</title>
</head>

<body>

<!-- Outer Wrapper -->
<div id="Wrapper">

	<!--========================================================
	>> Header
	=========================================================-->
	<header id="Header">
		<div id="Header-Inner">

			<div id="Header-Logo"></div>

			<!-- BEGIN: Social Links -->
			<ul id="Header-Social">
				<li>
					<a href="#" target="_blank" rel="nofollow" title="Like us on Facebook!">
						<i class="fa fa-facebook"></i>
						<span>Facebook</span>
					</a>
				</li>
				<li>
					<a href="#" target="_blank" rel="nofollow" title="Follow us on Twitter!">
						<i class="fa fa-twitter"></i>
						<span>Twitter</span>
					</a>
				</li>
				<li>
					<a href="#" target="_blank" rel="nofollow" title="Follow us on Google+!">
						<i class="fa fa-google-plus"></i>
						<span>Google+</span>
					</a>
				</li>
				<li>
					<a href="#" target="_blank" rel="nofollow" title="Keep up to date on our blog!">
						<i class="fa fa-rss"></i>
						<span>RSS Feed</span>
					</a>
				</li>
			</ul>
			<!-- END: Social Links -->

		</div>
	</header>
	
	<!--========================================================
	>> Section: Sale Domain Details
	=========================================================-->
	<section id="Domain-Details" class="Section Section-Basic">

		<div id="Details-Picture"></div>

		<div id="Details-Text">
			<h1><?php echo DOMAIN_NAME; ?></h1>
			<h2><?php echo DOMAIN_PRICE; ?></h2>
		</div>

		<div id="Details-Right">
			<a href="#Contact-Form" id="Details-Offer" class="No-Select">Make Offer</a>
		</div>

	</section>

	<!--========================================================
	>> Section: Domain Stats
	=========================================================-->
	<section id="Domain-Stats" class="Section">

		<ul id="Stats-Top" class="Clear">

			<li>
				<h2>Google Page Rank</h2>
				<h3>PR 3</h3>
			</li>

			<li>
				<h2>Google Indexed Pages</h2>
				<h3>17845</h3>
			</li>

			<li>
				<h2>Google Backlinks</h2>
				<h3>1532</h3>
			</li>

			<li>
				<h2>Alexa Rank</h2>
				<h3>2785</h3>
			</li>

		</ul>

		<ul id="Stats-Bottom" class="Clear">

			<li>
				<h2>Y! Indexed Pages</h2>
				<h3>540654</h3>
			</li>

			<li>
				<h2>Bing Indexed Pages</h2>
				<h3>435879</h3>
			</li>

			<li>
				<h2>Visits / Day</h2>
				<h3>2300</h3>
			</li>

			<li>
				<h2>Visits / Hour</h2>
				<h3>95</h3>
			</li>

		</ul>

		<div id="Stats-Toggle" class="No-Select">&lt;&lt; View Additional Stats &gt;&gt;</div>

	</section>

	<!--========================================================
	>> Section: Contact Form
	=========================================================-->
	<section id="Contact-Form" class="Section Section-Basic">
	
		<h1 class="Section-Title">Make an Offer</h1>
	
		<form id="Form" method="POST" action="<?php echo SITE_URL(); ?>Site-Mailer.php">
	
			<div id="Form-Status" class="Error">Test</div>
	
			<input type="text" id="Form-Name" name="Name" placeholder="Name" title="Name" spellcheck="false" <?php echo REQUIRED_NAME ? "required" : ''; ?>>
	
			<input type="text" id="Form-EMail" name="EMail" placeholder="E-Mail Address" title="E-Mail Address" spellcheck="false" <?php echo REQUIRED_EMAIL ? "required" : ''; ?>>
	
			<input type="text" id="Form-Phone" name="Phone" placeholder="Phone Number" title="Phone Number" <?php echo REQUIRED_PHONE ? "required" : ''; ?>>
	
			<input type="text" id="Form-Offer" name="Offer" placeholder="Offer / Bid" title="Offer / Bid" <?php echo REQUIRED_OFFER ? "required" : ''; ?>>
	
			<textarea id="Form-Message" name="Message" placeholder="Message" title="Message" <?php echo REQUIRED_MESSAGE ? "required" : ''; ?>></textarea>
	
			<?php 
				// ReCAPTCHA Integration - Controlled from Site-Config.php
				if ( CAPTCHA_ENABLED ):
			?>
				<div class="Clear"></div>
				<div id="Form-Captcha">
					<div class="g-recaptcha" data-sitekey="<?php echo CAPTCHA_KEY_PUBLIC; ?>"></div>			
				</div>
			<?php endif; ?>
	
			<div class="Clear"></div>
	
			<input type="submit" id="Form-Submit" value="Send Offer">
			<div id="Form-Sending">Sending...</div>
	
		</form>
	
	</section>

	<!--========================================================
	>> Section: Additional Domains
	=========================================================-->
	<section id="Additional-Domains" class="Section Section-Basic">

		<h1 class="Section-Title">More Domain Names for Sale</h1>

		<ul id="Domains-List">

			<li>
				<a href="#">AwesomeDomain.com</a><br>
				<span>Lorem ipsum dolor sit amet, con sectetuer adipiscing elit sediam.</span>
				<a href="#" class="Domain-Button">More Info</a>
			</li>

			<li>
				<a href="#">AmazingDomain.com</a><br>
				<span>Lorem ipsum dolor sit amet, con sectetuer adipiscing elit sediam.</span>
				<a href="#" class="Domain-Button">More Info</a>
			</li>

			<li>
				<a href="#">BestDomainEver.com</a><br>
				<span>Lorem ipsum dolor sit amet, con sectetuer adipiscing elit sediam.</span>
				<a href="#" class="Domain-Button">More Info</a>
			</li>

		</ul>

	</section>

	<!--========================================================
	>> Footer
	=========================================================-->
	<div id="Footer-Space"></div>
	<footer id="Footer">
		&#169; <strong>2016</strong> // YourDomain.com
	</footer>

</div><!-- END: Wrapper -->

</body>
</html>